/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.world.sound;

import club.sk1er.patcher.config.ConfigUtil;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.mixins.accessors.PositionedSoundAccessor;
import club.sk1er.patcher.mixins.accessors.SoundHandlerAccessor;
import club.sk1er.patcher.mixins.accessors.SoundRegistryAccessor;
import gg.essential.vigilance.data.PropertyData;
import gg.essential.vigilance.data.PropertyType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.Display;

public class SoundHandler
implements IResourceManagerReloadListener {
    private final Map<ResourceLocation, PropertyData> data = new HashMap<ResourceLocation, PropertyData>();

    @SubscribeEvent
    public void onSound(PlaySoundEvent event) {
        ISound soundResult = event.getResultSound();
        if (soundResult instanceof PositionedSoundAccessor) {
            PositionedSoundAccessor result = (PositionedSoundAccessor)soundResult;
            if (!Display.isActive()) {
                result.setVolume(result.getVolumeField() * PatcherConfig.unfocusedSounds);
            }
            result.setVolume(result.getVolumeField() * this.getVolumeMultiplier(soundResult.func_147650_b()));
        }
    }

    private float getVolumeMultiplier(ResourceLocation sound) {
        Object asAny;
        PropertyData propertyData = this.data.get(sound);
        if (propertyData != null && (asAny = propertyData.getAsAny()) instanceof Integer) {
            return ((Integer)asAny).floatValue() / 100.0f;
        }
        return 1.0f;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        Map<ResourceLocation, SoundEventAccessor> soundRegistry = ((SoundRegistryAccessor)((SoundHandlerAccessor)Minecraft.func_71410_x().func_147118_V()).getSndRegistry()).getSoundRegistry();
        for (Map.Entry<ResourceLocation, SoundEventAccessor> entry : soundRegistry.entrySet()) {
            this.data.computeIfAbsent(entry.getKey(), location -> {
                String name = this.getName((ResourceLocation)location);
                String[] category = ((SoundEventAccessor)entry.getValue()).func_188714_b().func_110623_a().split("\\.");
                return ConfigUtil.createAndRegisterConfig(PropertyType.SLIDER, WordUtils.capitalizeFully((String)category[0].replace("_", " ")), category.length > 2 ? WordUtils.capitalizeFully((String)category[1].replace("_", " ")) : "Sounds", name, "Sound Multiplier for " + name, 100, 0, 200, __ -> {});
            });
        }
    }

    private String getName(ResourceLocation location) {
        return WordUtils.capitalizeFully((String)location.func_110623_a().replace(".", " ").replace("_", " "));
    }
}

